/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.integration.crafttweaker.actions;

import com.blamejared.crafttweaker.api.action.base.IUndoableAction;
import java.util.Map;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.integration.crafttweaker.mappers.CrTConversionEMCMapper;

public class CustomConversionAction
implements IUndoableAction {
    private final CrTConversionEMCMapper.CrTConversion conversion;

    public CustomConversionAction(NormalizedSimpleStack output, int amount, Map<NormalizedSimpleStack, Integer> ingredients) {
        this.conversion = new CrTConversionEMCMapper.CrTConversion(output, amount, ingredients);
    }

    public void apply() {
        CrTConversionEMCMapper.addConversion(this.conversion);
    }

    public String describe() {
        StringBuilder inputString = new StringBuilder();
        for (Map.Entry<NormalizedSimpleStack, Integer> entry : this.conversion.ingredients().entrySet()) {
            int amount;
            if (inputString.length() > 0) {
                inputString.append(", ");
            }
            if ((amount = entry.getValue().intValue()) > 1) {
                inputString.append(amount).append(" ");
            }
            inputString.append(entry.getKey());
        }
        return "Added custom conversion creating '" + this.conversion.amount() + "' of " + this.conversion.output() + ", from: " + inputString;
    }

    public void undo() {
        CrTConversionEMCMapper.removeConversion(this.conversion);
    }

    public String describeUndo() {
        return "Undoing adding of custom conversion creating '" + this.conversion.amount() + "' of " + this.conversion.output();
    }
}

